﻿using System;

namespace HIPS.Web.UI.ViewModels.PcehrView
{

    /// <summary>
    /// View model for displaying the contents of a particular document.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="22 November 2013">Initial version.</change>
    /// </history>
    public class DocumentContentViewModel : PcehrViewModelBase
    {

        #region Properties

        /// <summary>
        /// Gets or sets the URL for the document to be displayed.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="22 November 2013">Initial version.</change>
        /// </history>
        public string DocumentUrl { get; set; }

        /// <summary>
        /// Gets or sets the date and time the document was downloaded.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="01 February 2014">Initial version.</change>
        /// </history>
        public DateTime DownloadTimestamp { get; set; }

        #endregion

    }
}